#version 120 

varying vec4 frontColor;
varying vec4 fragTexCoord;

uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 map_siz_inv;
varying float gamma_i;

void main ()
{
	// get texture 1 color
	vec4 texval1 = texture2D(tex0, fragTexCoord.st); 
	// get light map - texture 2 color
	vec4 texval2 = texture2D(tex1, gl_FragCoord.st * map_siz_inv); 

    if(gamma_i == 1.0)
    {
	    // mix color with lightmap
	    gl_FragColor = texval1 * vec4(texval2.rgb, 1.0) * frontColor;
    }
    else
    {
        texval1 = texval1 * vec4(texval2.rgb, 1.0) * frontColor;
        gl_FragColor = vec4( pow(texval1.rgb, vec3(gamma_i)), texval1.a);
    }
}
